#include "Joueur.h"
#include "Texture.h"

#include "CApplication.h"
#include "CProjectil.h"

#define scal 16.0

#define MAXLIFE 1000.0
#define NITROMAX 5000.0

void CJoueur::applyCollision(Vecteur pImpact,Vecteur forceImpact,float ampliImpact,float masse,unsigned char dmg)
{
    CApplication::selfPointer->o_son.playSound(IMPACTJ,pos.z,0.5);
    
    if(ampliImpact<0.0)ampliImpact=-ampliImpact;
    
    //if(masse<=0.0)masse=this->masse;
    
    masse*=ampliImpact;
    
    secousse+=0.065;
    secousse+=masse*0.02;
    if(secousse>2.0)secousse=2.0;
    
    shield-=dmg*masse;
    if(shield<=0.0)cldDisable(IN_LIFE);
    
    if(masse>0.0)ampliImpact=(masse/(this->masse))*0.4;
    else ampliImpact=ampliImpact*0.4;
        
    float t,t2,t3;
    Vecteur tt;
    
    //pImpact-=pos;
    //pImpact.normalize();
    
    mod.getAxeY(tt);
    t=tt*forceImpact;
    
    mod.getAxeX(tt);
    t2=tt*forceImpact;
    frot.z+=t2*t*ampliImpact;
    
    mod.getAxeZ(tt);
    t3=tt*forceImpact;
    frot.x+=t3*t*ampliImpact;
    
    frot.y+=t3*t2*ampliImpact;
    
    CApplication::selfPointer->mdp.addParticuleAleatPV(1,pImpact.x,pImpact.y,pImpact.z,vel.x,vel.y,vel.z,200,1.5,0.02);
    CApplication::selfPointer->mdp.addParticuleAleatPV(1,pImpact.x,pImpact.y,pImpact.z,vel.x,vel.y,vel.z,200,1.5,0.02);
    CApplication::selfPointer->mdp.addParticuleAleatPV(1,pImpact.x,pImpact.y,pImpact.z,vel.x,vel.y,vel.z,200,1.5,0.02);
    CApplication::selfPointer->mdp.addParticuleAleatPV(1,pImpact.x,pImpact.y,pImpact.z,vel.x,vel.y,vel.z,200,1.5,0.02);
}

void CJoueur::applyExplosion(float dmg,float proxi)
{
    proxi*=dmg;
    shield-=proxi;
    if(shield<=0.0)cldDisable(IN_LIFE);
    secousse+=proxi*0.06;
    if(secousse>2.0)secousse=2.0;
}

#define PI 3.1415926535897932384626433832795

//char *zikDead[1]={".\\Media\\Music\\starfox - Super Smash Brothers Melee - Corneria.ogg"};
char *zikDead[1]={".\\Media\\Music\\Epoq-Lepidoptera.ogg"};

/*
#include <pthread/pthread.h>

void *threadChgMusic(void *data)
{
    CApplication::selfPointer->o_music.launchMusicList(1,zikDead);
}
*/

bool CJoueur::frameMove(float elapsedTime)
{
    if(colid_flags==IS_REF)
    {
        secousse=0.0;
        CApplication::selfPointer->o_son.stopReacteurLoop();
        CApplication::selfPointer->o_music.stopMusic();
        
        /*
        CApplication::selfPointer->id=CApplication::selfPointer->o_music.getId();
        pthread_t musicThrd;
        pthread_create(&musicThrd,NULL,threadChgMusic,NULL);
        */
        
        if(rand()%2)
        {
            CApplication::selfPointer->mCld.addExplosion(new CExplositonAnim(pos.x,pos.y,pos.z,0.5,20000.0,rayon*0.5,rayon*5.0,8,16,16/2500.0,128.0/1024.0,128.0/1024.0,0));
            CApplication::selfPointer->mCld.addExplosion(new CExplositonAnim(pos.x,pos.y,pos.z,0.5,20000.0,rayon*0.5,rayon*5.0,8,16,16/2500.0,128.0/1024.0,128.0/1024.0,5));
            CApplication::selfPointer->mCld.addExplosion(new CExplositonAnim(pos.x,pos.y,pos.z,0.5,20000.0,rayon*0.5,rayon*5.0,8,16,16/2500.0,128.0/1024.0,128.0/1024.0,11));
        }
        else
        {
            CApplication::selfPointer->mCld.addExplosion(new CExplositonAnim(pos.x,pos.y,pos.z,0.5,20000.0,rayon*0.5,rayon*5.0,8,16+17,17/2500.0,128.0/1024.0,128.0/1024.0,16));
            CApplication::selfPointer->mCld.addExplosion(new CExplositonAnim(pos.x,pos.y,pos.z,0.5,20000.0,rayon*0.5,rayon*5.0,8,16+17,17/2500.0,128.0/1024.0,128.0/1024.0,21));
            CApplication::selfPointer->mCld.addExplosion(new CExplositonAnim(pos.x,pos.y,pos.z,0.5,20000.0,rayon*0.5,rayon*5.0,8,16+17,17/2500.0,128.0/1024.0,128.0/1024.0,27));
        }
        srand((time_t) rand());
        
        CItEnnemi::setCiblePosVel(NULL,NULL);
        CApplication::selfPointer->o_son.playSound(EXPLOJR,pos.z);
        
        CApplication::selfPointer->setMusicId(CApplication::selfPointer->o_music.getId());
        CApplication::selfPointer->o_music.launchMusic(zikDead[0]);
        
        //colid_flags|=IS_REC;
         
        return true;
    }
    
    if(shield<MAXLIFE)
    {
        shield+=0.01*elapsedTime;
        if(shield>MAXLIFE)shield=MAXLIFE;
    }
    
    if(nitro<NITROMAX)
    {
        if(nitro<10.0)nitro+=0.05*elapsedTime;
        else nitro+=0.25*(1.0+nitro/NITROMAX)*elapsedTime;
        if(nitro>NITROMAX)nitro=NITROMAX;
    }
    
    if(pos.x<-750.0){pos.x=-750.0;}
    else if(pos.x>750.0){pos.x=750.0;}
    
    if(pos.y<-550.0)pos.y=-550.0;
    else if(pos.y>550.0)pos.y=550.0;
    
    forceFrotement(frot.z,0.994,elapsedTime);
    
    bool mode;
    if(cMant && cMant->mode)mode=true;
    else mode=false;
    
    if(mode)
    {
     forceFrotement(frot.x,0.95,elapsedTime);//0.997
     forceFrotement(frot.y,0.95,elapsedTime);
     
     if(rot.x<-(PI/4))rot.x=-(PI/4);
     else if(rot.x>(PI/4))rot.x=(PI/4);
     if(rot.y<-(PI/4))rot.y=-(PI/4);
     else if(rot.y>(PI/4))rot.y=(PI/4);
    }
    else
    {
     forceFrotement(frot.x,0.99,elapsedTime);//0.997
     forceFrotement(frot.y,0.99,elapsedTime);
    
     forceFrotement(rot.x,0.9965,elapsedTime);//0.987
     forceFrotement(rot.y,0.9965,elapsedTime);
    }
    
    forceFrotement(rot.z,0.995,elapsedTime);
    
    if(secousse!=0.0)
    {
        forceFrotement(secousse,0.997,elapsedTime);
        if(secousse<0.000001)secousse=0.0;
    }
    
    if(pos.x<-700.0)frot.y+=0.00005*elapsedTime;
    else if(pos.x>700.0)frot.y-=0.00005*elapsedTime;
    
    if(pos.y<-500.0)frot.x+=0.00005*elapsedTime;
    else if(pos.y>500.0)frot.x-=0.00005*elapsedTime;
    
    bool accel,latt;
    
    if(cMant)
    {
        /*
        bool du=cMant->kDown||cMant->kUp;
        bool lr=cMant->kLeft||cMant->kRight;
        
        if(cMant->kLeft)frot.y+=(du?0.00008:0.0001)*elapsedTime;
        if(cMant->kRight)frot.y-=(du?0.00008:0.0001)*elapsedTime;
        if(cMant->kDown)frot.x-=(lr?0.00008:0.0001)*elapsedTime;
        if(cMant->kUp)frot.x+=(lr?0.00008:0.0001)*elapsedTime;
        */
        
        bool mvClv=true;
        
        latt=cMant->kZLeft|cMant->kZRight;
        
        if(mode)
        {
         if(cMant->kZLeft){frot.z+=0.00004*elapsedTime;mvClv=false;}
         if(cMant->kZRight){frot.z-=0.00004*elapsedTime;mvClv=false;}
         if(!latt)
         {
             if(cMant->kLeft){frot.y+=0.00008*elapsedTime;mvClv=false;}
             if(cMant->kRight){frot.y-=0.00008*elapsedTime;mvClv=false;}
         }
         
         if(cMant->kDown){frot.x+=0.00008*elapsedTime;mvClv=false;}
         if(cMant->kUp){frot.x-=0.00008*elapsedTime;mvClv=false;}
         
         if(cMant->mAct)
         {
             //cMant->centerMouse();
             if(mvClv)
             {
                 frot.y=-cMant->pmx*elapsedTime;
                 frot.x=-cMant->pmy*elapsedTime;
             }
         }
        }
        else
        {
         if(cMant->kZLeft){frot.z+=0.00004*elapsedTime;mvClv=false;}
         if(cMant->kZRight){frot.z-=0.00004*elapsedTime;mvClv=false;}
         if(!latt)
         {
             if(cMant->kLeft){frot.y+=0.00006*elapsedTime;mvClv=false;}
             if(cMant->kRight){frot.y-=0.00006*elapsedTime;mvClv=false;}
         }
         
         if(cMant->kDown){frot.x+=0.00006*elapsedTime;mvClv=false;}
         if(cMant->kUp){frot.x-=0.00006*elapsedTime;mvClv=false;}
         
         if(cMant->mAct)
         {
             //cMant->centerMouse();
             if(mvClv)
             {
                 frot.y-=cMant->pmx*elapsedTime;
                 frot.x-=cMant->pmy*elapsedTime;
             }
         }
        }
        
        if(cMant->kShift && nitro>=elapsedTime)
        {
            nitro-=elapsedTime;
            accel=true;
            secousse+=0.00025*elapsedTime;
            if(secousse>2.0)secousse=2.0;
            if(!cMant->sReact)
            {
                cMant->sReact=true;
                CApplication::selfPointer->o_son.playReacteurLoop();
            }
        }
        else
        {
            accel=false;
            if(cMant->sReact)
            {
                cMant->sReact=false;
                CApplication::selfPointer->o_son.stopReacteurLoop();
            }
        }
    }
    else
    {
        accel=false;
        latt=false;
        if(cMant->sReact)
        {
            cMant->sReact=false;
            CApplication::selfPointer->o_son.stopReacteurLoop();
        }
    }
    
    Vecteur t(frot);
    t*=0.4*elapsedTime;
    //t.z=t.y*0.6;
    rot+=t;
    
    //if(rot.z<-PI/4)rot.z=-PI/4;
    //if(rot.z>PI/4)rot.z=PI/4;
    //if(rot.x<-PI/4.1)rot.x=-PI/4.1;
    //if(rot.x>PI/4.1)rot.x=PI/4.1;
    
    mod.setRotation(rot.x,rot.y,rot.z);
    
    if(cMant)
    {
        if(timeShot>0.0)timeShot-=elapsedTime;
        if(timeShotM>0.0)timeShotM-=elapsedTime;
        if(cMant->kSpace)
        {
            if((timeShot<=0.0 && cMant->chiffre<='4') || (timeShotM<=0.0 && cMant->chiffre>='5'))
            {
                Vecteur vl;
                mod.getAxeZ(vl);
                
                t.y=(0.0/4.0)*scal;//0.1;
                t.z=rayon+0.01;//0.521946;
                
                if(cMant->chiffre=='0')
                {
                    vl*=1.3;
                    timeShot=100.0;
                    
                    t.x=(0.0/4.0)*scal;//0.521946;
                    mod.multVect(t,t);
                    
                    t+=pos;
                    
                    CApplication::selfPointer->o_son.playSound(MONOSHOT,pos.z,0.8);
                    CApplication::selfPointer->mCld.addLaser(new CProjectil(LASERBLEU,3000.0,110,t.x,t.y,t.z,0.0,0.0,0.0,vl.x,vl.y,vl.z,0.5,1.0,0.0,1.0));
                }
                else if(!cMant || cMant->chiffre=='1')
                {
                    vl*=1.3;
                    timeShot=150.0;
                    
                    t.x=(-0.32/4.0)*scal;//0.521946;
                    mod.multVect(t,t);
                    
                    t+=pos;
                    
                    CApplication::selfPointer->o_son.playSound(DUALSHOT,pos.z);
                    CApplication::selfPointer->mCld.addLaser(new CProjectil(LASERJAUNE,3000.0,85,t.x,t.y,t.z,0.0,0.0,0.0,vl.x,vl.y,vl.z,0.5,1.0,0.0,1.0));
                    Vecteur tt;
                    mod.getAxeX(tt);
                    tt*=((0.32*2)/4.0)*scal;
                    t+=tt;
                    CApplication::selfPointer->mCld.addLaser(new CProjectil(LASERJAUNE,3000.0,85,t.x,t.y,t.z,0.0,0.0,0.0,vl.x,vl.y,vl.z,0.5,1.0,0.0,1.0));
                }
                else if(!cMant || cMant->chiffre=='2')
                {
                    vl*=1.3;
                    timeShot=110.0;
                    
                    t.x=((bRL?0.35:-0.35)/4.0)*scal;//0.521946;
                    mod.multVect(t,t);
                    
                    if(bRL)bRL=false;else bRL=true;
                    
                    t+=pos;
                    
                    CApplication::selfPointer->o_son.playSound(MONOSHOT,pos.z,0.8);
                    CApplication::selfPointer->mCld.addLaser(new CProjectil(LASERVERT,3000.0,120,t.x,t.y,t.z,0.0,0.0,0.0,vl.x,vl.y,vl.z,0.5,1.0,0.0,1.0));
                }
                else if(!cMant || cMant->chiffre=='3')
                {
                    vl*=1.3;
                    timeShot=240.0;
                    
                    t.x=(-0.4/4.0)*scal;//0.521946;
                    mod.multVect(t,t);
                    
                    t+=pos;
                    
                    CApplication::selfPointer->o_son.playSound(TREESHOT,pos.z,0.55);
                    CApplication::selfPointer->mCld.addLaser(new CProjectil(LASERCYAN,3000.0,120,t.x,t.y,t.z,0.0,0.0,0.0,vl.x,vl.y,vl.z,0.5,1.0,0.0,1.0));
                    Vecteur tt,tt2;
                    mod.getAxeX(tt);
                    mod.getAxeZ(tt2);
                    tt*=((0.4)/4.0)*scal;
                    tt2*=((2.0)/4.0)*scal;
                    t+=tt;
                    CApplication::selfPointer->mCld.addLaser(new CProjectil(LASERCYAN,3000.0,120,t.x+tt2.x,t.y+tt2.y,t.z+tt2.z,0.0,0.0,0.0,vl.x,vl.y,vl.z,0.5,1.0,0.0,1.0));
                    t+=tt;
                    CApplication::selfPointer->mCld.addLaser(new CProjectil(LASERCYAN,3000.0,120,t.x,t.y,t.z,0.0,0.0,0.0,vl.x,vl.y,vl.z,0.5,1.0,0.0,1.0));
                }
                else if(!cMant || cMant->chiffre=='4')
                {
                    vl*=1.3;
                    timeShot=130.0;
                    
                    t.x=(((bRL==true)?-0.4:((bRL==0x55 || bRL==false)?0.0:0.4))/4.0)*scal;//0.521946;
                    mod.multVect(t,t);
                    
                    if(bRL==true)bRL=0x55;
                    else if(bRL==0x55)bRL=0xAA;
                    else if(bRL==0xAA)bRL=false;
                    else bRL=true;
                    
                    t+=pos;
                    
                    CApplication::selfPointer->o_son.playSound(MONOSHOT,pos.z,0.8);
                    CApplication::selfPointer->mCld.addLaser(new CProjectil(LASERROUGE,3000.0,150,t.x,t.y,t.z,0.0,0.0,0.0,vl.x,vl.y,vl.z,0.5,1.0,0.0,1.0));
                }
                else if(cMant->chiffre=='5')
                {
                    timeShotM=100.0;
                    
                    t.x=((bRL?0.29:-0.29)/4.0)*scal;//0.521946;
                    t.z+=5.0;
                    mod.multVect(t,t);
                    
                    if(bRL)bRL=false;else bRL=true;
                    
                    t+=pos;
                    
                    secousse+=0.0015*elapsedTime;
                    if(secousse>2.0)secousse=2.0;
                    CApplication::selfPointer->o_son.playSound(MSL1,pos.z,0.5);
                    CApplication::selfPointer->mCld.addCollideSf(new CMissile(MISSILE1,3000.0,45,t.x,t.y,t.z,vl.x,vl.y,vl.z,vel.x*2,vel.y*2,vel.z*2,5.0,5.0,0.0,0.99));
                }
                else if(cMant->chiffre=='6')
                {
                    timeShotM=170.0;
                    
                    t.x=((bRL?0.29:-0.29)/4.0)*scal;//0.521946;
                    t.z+=6.5;
                    mod.multVect(t,t);
                    
                    if(bRL)bRL=false;else bRL=true;
                    
                    t+=pos;
                    
                    secousse+=0.003*elapsedTime;
                    if(secousse>2.0)secousse=2.0;
                    CApplication::selfPointer->o_son.playSound(MSL2,pos.z,0.5);
                    CApplication::selfPointer->mCld.addCollideSf(new CMissile(MISSILE2,4000.0,60,t.x,t.y,t.z,vl.x,vl.y,vl.z,vel.x*2,vel.y*2,vel.z*2,5.0,6.5,0.0,0.99));
                }
                else if(cMant->chiffre=='7')
                {
                    timeShotM=200.0;
                    
                    t.x=((bRL?0.29:-0.29)/4.0)*scal;//0.521946;
                    t.z+=8.0;
                    mod.multVect(t,t);
                    
                    if(bRL)bRL=false;else bRL=true;
                    
                    t+=pos;
                    
                    secousse+=0.0035*elapsedTime;
                    if(secousse>2.0)secousse=2.0;
                    CApplication::selfPointer->o_son.playSound(MSL3,pos.z,0.5);
                    CApplication::selfPointer->mCld.addCollideSf(new CMissile(MISSILE3,4000.0,70,t.x,t.y,t.z,vl.x,vl.y,vl.z,vel.x*2,vel.y*2,vel.z*2,5.0,8.0,0.0,0.99));
                }
                else if(cMant->chiffre=='8')
                {
                    timeShotM=230.0;
                    
                    //t.x=((bRL?0.29:-0.29)/4.0)*scal;//0.521946;
                    Vecteur vz;
                    t.z+=6.0;
                    mod.getAxeZ(vz);
                    vz*=t.z;
                    t=vz;
                    //mod.multVect(t,t);
                    
                    //if(bRL)bRL=false;else bRL=true;
                    
                    t+=pos;
                    
                    secousse+=0.0034*elapsedTime;
                    if(secousse>2.0)secousse=2.0;
                    CApplication::selfPointer->o_son.playSound(MSL4,pos.z,0.4);
                    CApplication::selfPointer->mCld.addCollideSf(new CMissileEn(MISSILE4,4000.0,50,t.x,t.y,t.z,vl.x,vl.y,vl.z,vel.x*2,vel.y*2,vel.z*2,6.0,8.0,0.0,0.99));
                }
                else if(cMant->chiffre=='9')
                {
                    timeShotM=290.0;
                    
                    //t.x=((bRL?0.29:-0.29)/4.0)*scal;//0.521946;
                    Vecteur vz;
                    t.z+=7.0;
                    mod.getAxeZ(vz);
                    vz*=t.z;
                    t=vz;
                    //mod.multVect(t,t);
                    
                    //if(bRL)bRL=false;else bRL=true;
                    
                    t+=pos;
                    
                    secousse+=0.004*elapsedTime;
                    if(secousse>2.0)secousse=2.0;
                    CApplication::selfPointer->o_son.playSound(MSL5,pos.z,0.5);
                    CApplication::selfPointer->mCld.addCollideSf(new CMissileEn(MISSILE5,4000.0,60,t.x,t.y,t.z,vl.x,vl.y,vl.z,vel.x*2,vel.y*2,vel.z*2,7.0,8.0,0.0,0.99));
                }
            }
        }
    }
    
    mod.getAxeZ(force);
    
    //m2.vel=force;
    //m2.vel*=0.0001*0;
    //m1.vel=m2.vel;
    
    if(accel)
    {
        force*=0.0037*2;
        //force.y*=1.2;
        //force.x*=1.2;
    }
    else
    {
        force*=0.0033;
        force.x*=1.5;
        force.y*=1.5;
    }
    //force.y+=0.000097;
    
    mod.getAxeY(t);
    //force.x+=t.x*(accel?0.002*2:0.002);
    force.y+=t.y*0.000097;
    
    if(latt)force.x+=t.x*0.016;
    
    if(m1.predict(elapsedTime))
    {
        /*
        t.x=(0.29/4.0)*scal;//0.521946;
        t.y=(0.0/4.0)*scal;//0.1;
        t.z=(-0.5/4.0)*scal;//0.521946;
        mod.multVect(m1.pos,t);
        
        mod.getAxeX(t);
        t*=(-0.29/2.0)*scal;;
        m2.pos=m1.pos;
        m2.pos+=t;
        
        m1.pos+=pos;
        m2.pos+=pos;
        
        m1.vel=vel;
        //m1.vel.x+=force.x*(elapsedTime/4);
        m2.vel=m1.vel;
        */
        
        t.x=(0.0/4.0)*scal;//0.521946;
        t.y=(0.2*0/4.0)*scal;//0.1;
        t.z=(-2.05/4.0)*scal;//0.521946;
        mod.multVect(m1.pos,t);
        m1.pos+=pos;
        m1.vel=vel;
    }
        
    m1.frameMove(elapsedTime);
    //m2.frameMove(elapsedTime);
    
    return false;
}

void CJoueur::render()
{
    mod.draw(pos.x,pos.y,pos.z);
    /*
    glPushMatrix();
    glTranslatef(pos.x,pos.y,pos.z);
    glutSolidSphere(rayon,16,16);
    glPopMatrix();
    */
}

#define StartPosZ 6.0

CJoueur::CJoueur()//r=0.521946
:CCollideMv(0.0,700.0,StartPosZ, // POS
            0.0,0.000097,0.002, // FORCE
            0.0,-3.5,12.0, // VEL
            100.0, // MASSE
            0.521946*scal, // RAYON
            0.5, // COEFELASTIC
            0.99) // FFrot
{
    cMant=NULL;
    m1.setIdP(0);//m2.setIdP(0);
    m1.setReTm(10.0);//m2.setReTm(10.0);
    m1.setLife(140);//m2.setLife(70);
    m1.start();//m2.start();
    timeShot=0.0;
    timeShotM=0.0;
    bRL=true;
    idCross=0xFFFFFFFF;
    shield=MAXLIFE;
    //cldEnable(IN_LIFE);
    cldEnable(IS_REF);
    ressus=0;
    dmg=1;
    secousse=2.0;
    nitro=NITROMAX;
}

//fonction de test si rssusite (le joueur reviens aprzs un certain temps quand il est mort)
bool CJoueur::ressusiter(unsigned int elapsedTime)
{
    if(colid_flags==IS_REF)
    {
        ressus+=elapsedTime;
        if(ressus>=20000 || (cMant && cMant->kR && ressus>=3000))
        {                      
            pos.x=0.0;pos.y=700.0;pos.z=StartPosZ;
            force.x=0.0;force.y=0.000097;force.z=0.002;
            vel.x=0.0;vel.y=-3.5;vel.z=12.0;
            
            timeShot=0.0;
            timeShotM=0.0;
            bRL=true;
            //idCross=0xFFFFFFFF;
            shield=MAXLIFE;
            //cldEnable(IN_LIFE);
            //cldEnable(IS_REF);
            colid_flags=IN_LIFE|IS_REF;
            ressus=0;
            
            frot.x=frot.y=frot.z=0.0;
            rot.x=rot.y;rot.z=0.0;
            
            secousse=2.0;
            
            nitro=NITROMAX;
            
            return true;
        }
    }
    
    return false;
}

CJoueur::~CJoueur()
{
    if(idCross!=0xFFFFFFFF)
    {
        glDeleteLists(idCross,1);
        idCross=0xFFFFFFFF;
    }
}

#include "math.h"
#define crsScl 8.0
#define PI 3.1415926535897932384626433832795
#define subD 8

//initialisation graphique (modle et cross)
void CJoueur::initGraphX()
{
    //r=0.521946*scal
    //mod.loadObj(".\\Media\\Avions\\avion.bob",CTexture::GetInstance()->getTexture(".\\Media\\Avions\\AIRPL004.bmp"),scal,0.0,0.0,0.0);
    mod.loadObj(CApplication::selfPointer->protoBob.getPrototype(SHIP1));
    
    idCross=glGenLists(1);
    glNewList(idCross, GL_COMPILE);
    //glLineWidth(2.0);
    glBegin(GL_LINE_LOOP);
    //glVertex3f(1.0*crsScl,-1.0*crsScl,0.0*crsScl);
    //glVertex3f(1.0*crsScl,1.0*crsScl,0.0*crsScl);
    //glVertex3f(-1.0*crsScl,1.0*crsScl,0.0*crsScl);
    //glVertex3f(-1.0*crsScl,-1.0*crsScl,0.0*crsScl);
    float ag;
    for(ag=0.0;ag<=2*PI;ag+=PI/subD)
    {
        glVertex3f(cosf(ag)*crsScl,sinf(ag)*crsScl,0.0*crsScl);
    }
    glEnd();
    glBegin(GL_LINES);
    glVertex3f(1.3*crsScl,0.0*crsScl,0.0*crsScl);
    glVertex3f(0.7*crsScl,0.0*crsScl,0.0*crsScl);
    glVertex3f(-1.3*crsScl,0.0*crsScl,0.0*crsScl);
    glVertex3f(-0.7*crsScl,0.0*crsScl,0.0*crsScl);
    glVertex3f(0.0*crsScl,1.3*crsScl,0.0*crsScl);
    glVertex3f(0.0*crsScl,0.7*crsScl,0.0*crsScl);
    glVertex3f(0.0*crsScl,-1.3*crsScl,0.0*crsScl);
    glVertex3f(0.0*crsScl,-0.7*crsScl,0.0*crsScl);
    glEnd();
    glEndList();
}

//affichage de l'interface
void CJoueur::rendCross()
{
    if(colid_flags==(IS_REF|IN_LIFE))
    {
        glDisable(GL_DEPTH_TEST);
        glDisable(GL_LIGHTING);
        glDisable(GL_TEXTURE_2D);
        glPushMatrix();
        if(idCross!=0xFFFFFFFF)
        {
            Vecteur p;
            mod.getAxeZ(p);
            p*=500.0;
            p+=pos;
            glTranslatef(p.x,p.y,p.z);
            glCallList(idCross);
        }
        
        glLoadIdentity();
        
        //#define crrX -0.60577
        #define crrY -(0.46192-0.003)
        //#define crxX -0.35577
        #define crxY -0.45231
        #define crDlt (0.125/MAXLIFE)
        #define crDltMX 0.125
        
        #define ILB_SCL 2.0f
        
        glColor3f(1.0,0.0,0.0);
        glBegin(GL_QUADS);
        
        glVertex3f(-crDlt*shield*ILB_SCL,crxY*ILB_SCL,-1.0);
        glVertex3f(-crDlt*shield*ILB_SCL,crrY*ILB_SCL,-1.0);
        glVertex3f(crDlt*shield*ILB_SCL,crrY*ILB_SCL,-1.0);
        glVertex3f(crDlt*shield*ILB_SCL,crxY*ILB_SCL,-1.0);
        
        glEnd();
        
        glColor3f(1.0,1.0,1.0);
        glBegin(GL_LINE_LOOP);
        
        glVertex3f(-crDltMX*ILB_SCL,crxY*ILB_SCL,-1.0);
        glVertex3f(-crDltMX*ILB_SCL,crrY*ILB_SCL,-1.0);
        glVertex3f(crDltMX*ILB_SCL,crrY*ILB_SCL,-1.0);
        glVertex3f(crDltMX*ILB_SCL,crxY*ILB_SCL,-1.0);
        
        glEnd();
        
        glBegin(GL_LINES);
        
        glVertex3f(-0.01*ILB_SCL,crxY*ILB_SCL,-1.0);
        glVertex3f(-0.01*ILB_SCL,crrY*ILB_SCL,-1.0);
        
        glVertex3f(0.01*ILB_SCL,crxY*ILB_SCL,-1.0);
        glVertex3f(0.01*ILB_SCL,crrY*ILB_SCL,-1.0);
        
        //glVertex3f(-crDltMX,crrY+0.004805,-1.0);
        //glVertex3f(crDltMX,crrY+0.004805,-1.0);
        glEnd();
        
        #define ArY (crrY-0.012)
        #define AxY (crxY-0.012)
        #define ADlt (0.125/NITROMAX)
        #define ADltMX 0.125
        
        glColor3f(0.0,0.0,1.0);
        glBegin(GL_QUADS);
        
        glVertex3f(-ADlt*nitro*ILB_SCL,AxY*ILB_SCL,-1.0);
        glVertex3f(-ADlt*nitro*ILB_SCL,ArY*ILB_SCL,-1.0);
        glVertex3f(ADlt*nitro*ILB_SCL,ArY*ILB_SCL,-1.0);
        glVertex3f(ADlt*nitro*ILB_SCL,AxY*ILB_SCL,-1.0);
        
        glEnd();
        
        glColor3f(1.0,1.0,1.0);
        glBegin(GL_LINE_LOOP);
        
        glVertex3f(-ADltMX*ILB_SCL,AxY*ILB_SCL,-1.0);
        glVertex3f(-ADltMX*ILB_SCL,ArY*ILB_SCL,-1.0);
        glVertex3f(ADltMX*ILB_SCL,ArY*ILB_SCL,-1.0);
        glVertex3f(ADltMX*ILB_SCL,AxY*ILB_SCL,-1.0);
        
        glEnd();
        
        glBegin(GL_LINES);
        
        glVertex3f(-0.01*ILB_SCL,AxY*ILB_SCL,-1.0);
        glVertex3f(-0.01*ILB_SCL,ArY*ILB_SCL,-1.0);
        
        glVertex3f(0.01*ILB_SCL,AxY*ILB_SCL,-1.0);
        glVertex3f(0.01*ILB_SCL,ArY*ILB_SCL,-1.0);
        
        glEnd();
        
        glPopMatrix();
        glEnable(GL_LIGHTING);
        glEnable(GL_DEPTH_TEST);
    }
}

//libration graphique du modle
void CJoueur::clearGraphX()
{
    mod.clear();
}

//obtenir le dplacement du joueur
float CJoueur::getMvmnt()
{
    return (colid_flags==(IS_REF|IN_LIFE))?(pos.z-StartPosZ):0.0;
}

//placer la camra suivant le joueur
void CJoueur::fixCam()
{
    if(secousse!=0.0)
    {
        Vecteur v1
        (
            ((((float)rand())/RAND_MAX)*2.0-1.0)*secousse,
            ((((float)rand())/RAND_MAX)*2.0-1.0)*secousse,
            ((((float)rand())/RAND_MAX)*2.0-1.0)*secousse
        );
        Vecteur v2
        (
            ((((float)rand())/RAND_MAX)*2.0-1.0)*secousse,
            ((((float)rand())/RAND_MAX)*2.0-1.0)*secousse,
            ((((float)rand())/RAND_MAX)*2.0-1.0)*secousse
        );
        
        gluLookAt(pos.x+v1.x,pos.y+((2.0/4.0)*scal)+v1.y,StartPosZ-((6.0/4.0)*scal)+v1.z,
                pos.x+v2.x,pos.y+((1.0/4.0)*scal)+v2.y,StartPosZ+((6.0/4.0)*scal)+v2.z,
                0.0,1.0,0.0);
        srand((time_t) rand());
    }
    else
    {
        gluLookAt(pos.x,pos.y+((2.0/4.0)*scal),StartPosZ-((6.0/4.0)*scal),
                pos.x,pos.y+((1.0/4.0)*scal),StartPosZ+((6.0/4.0)*scal),
                0.0,1.0,0.0);
    }
}

//n'appliquer que la position de la camra (pour dessiner la sky box)
void CJoueur::translateCam()
{
    glTranslatef(pos.x,pos.y+4.0,StartPosZ-6.0);
}

//mettre une manette au joueur
void CJoueur::setManette(CManette *cMant){this->cMant=cMant;}

//retourne un pointeur sur la position et la vitesse du joueur
void CJoueur::getPtrCible(Vecteur *&p,Vecteur *&v)
{
    p=&pos;
    v=&vel;
}
